"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_components_frontend_auth_ForgotPasswordVerifyComponent_vue"],{

/***/ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js":
/*!**************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js ***!
  \**************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _components_LoadingComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../components/LoadingComponent */ "./resources/js/components/frontend/components/LoadingComponent.vue");
/* harmony import */ var _services_alertService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../services/alertService */ "./resources/js/services/alertService.js");
/* harmony import */ var _config_env__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../config/env */ "./resources/js/config/env.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: "ForgotPasswordVerifyComponent",
  components: {
    LoadingComponent: _components_LoadingComponent__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data: function data() {
    return {
      loading: {
        isActive: false
      },
      props: {
        form: {
          email: "",
          phone: "",
          token: "",
          country_code: ""
        }
      },
      APP_URL: _config_env__WEBPACK_IMPORTED_MODULE_2__["default"].API_URL,
      errors: "",
      message: null
    };
  },
  mounted: function mounted() {
    this.phoneOrEmailChecking();
  },
  methods: {
    phoneOrEmailChecking: function phoneOrEmailChecking() {
      this.loading.isActive = true;
      var otpPhone = this.$store.getters['phone'];
      var otpEmail = this.$store.getters['email'];
      if (Object.keys(otpPhone).length > 0 && otpPhone.otp.phone !== "") {
        this.props.form.phone = otpPhone.otp.phone;
        this.props.form.country_code = otpPhone.otp.country_code;
        this.props.form.email = "";
        this.loading.isActive = false;
      } else if (Object.keys(otpEmail).length > 0 && otpPhone.otp.email !== "") {
        this.props.form.email = otpPhone.otp.email;
        this.props.form.phone = "";
        this.props.form.country_code = "";
        this.loading.isActive = false;
      } else {
        this.$router.push({
          name: 'auth.login'
        });
      }
      this.loading.isActive = false;
    },
    resendCodeToPhone: function resendCodeToPhone() {
      var _this = this;
      try {
        this.loading.isActive = true;
        this.$store.dispatch("otpPhone", this.props.form).then(function (res) {
          _this.loading.isActive = false;
          _this.errors = "";
          _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].success(res.data.message, 'bottom-center');
        })["catch"](function (err) {
          _this.loading.isActive = false;
          _this.errors = err.response.data.message;
        });
      } catch (err) {
        this.loading.isActive = false;
        _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].error(err);
      }
    },
    resendCodeToEmail: function resendCodeToEmail() {
      var _this2 = this;
      try {
        this.loading.isActive = true;
        this.$store.dispatch("otpEmail", this.props.form).then(function (res) {
          _this2.loading.isActive = false;
          _this2.errors = "";
          _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].success(res.data.message, 'bottom-center');
        })["catch"](function (err) {
          _this2.loading.isActive = false;
          _this2.errors = err.response.data.message;
        });
      } catch (err) {
        this.loading.isActive = false;
        _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].error(err);
      }
    },
    save: function save() {
      var _this3 = this;
      try {
        this.loading.isActive = true;
        if (this.props.form.country_code !== "" && this.props.form.phone !== "") {
          this.$store.dispatch("forgotPasswordVerifyPhone", this.props.form).then(function (res) {
            _this3.loading.isActive = false;
            _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].success(res.data.message, 'bottom-center');
            _this3.props.form = {
              email: "",
              phone: "",
              token: "",
              country_code: ""
            };
            _this3.errors = '';
            _this3.$router.push({
              name: "auth.resetPassword"
            });
          })["catch"](function (err) {
            _this3.loading.isActive = false;
            _this3.errors = err.response.data.message;
          });
        } else {
          this.$store.dispatch("forgotPasswordVerifyEmail", this.props.form).then(function (res) {
            _this3.loading.isActive = false;
            _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].success(res.data.message, 'bottom-center');
            _this3.props.form = {
              email: "",
              phone: "",
              token: "",
              country_code: ""
            };
            _this3.errors = '';
            _this3.$router.push({
              name: "auth.resetPassword"
            });
          })["catch"](function (err) {
            _this3.loading.isActive = false;
            _this3.errors = err.response.data.message;
          });
        }
      } catch (err) {
        this.loading.isActive = false;
        _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].error(err);
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be":
/*!******************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be ***!
  \******************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "w-full max-w-3xl mx-auto rounded-2xl flex overflow-hidden gap-y-6 bg-white shadow-card mb-24 sm:mb-0"
};
var _hoisted_2 = ["src"];
var _hoisted_3 = {
  "class": "text-center relative mb-8"
};
var _hoisted_4 = {
  "class": "capitalize text-2xl mb-2 font-bold text-primary"
};
var _hoisted_5 = {
  key: 0,
  "class": "bg-red-100 border border-red-400 text-red-700 px-4 py-3 mb-5 rounded relative",
  role: "alert"
};
var _hoisted_6 = {
  "class": "block sm:inline"
};
var _hoisted_7 = {
  "class": "mb-6"
};
var _hoisted_8 = {
  "class": "text-sm font-medium capitalize mb-1 field-title required"
};
var _hoisted_9 = {
  key: 0,
  "class": "db-field-alert"
};
var _hoisted_10 = {
  "class": "block mt-3 text-center text-sm font-medium"
};
var _hoisted_11 = {
  type: "submit",
  "class": "font-bold text-center w-full h-12 leading-12 rounded-full bg-primary text-white mb-6"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_LoadingComponent = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("LoadingComponent");
  var _component_router_link = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("router-link");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_LoadingComponent, {
    props: $data.loading
  }, null, 8 /* PROPS */, ["props"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
    src: $data.APP_URL + '/images/required/auth.jpg',
    alt: "banners",
    "class": "w-full hidden sm:block sm:max-w-xs md:max-w-sm flex-shrink-0"
  }, null, 8 /* PROPS */, _hoisted_2), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("form", {
    "class": "w-full p-6",
    onSubmit: _cache[4] || (_cache[4] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {
      return $options.save && $options.save.apply($options, arguments);
    }, ["prevent"]))
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    to: {
      name: 'auth.forgotPassword'
    },
    "class": "absolute top-1/2 ltr:left-0 rtl:right-0 -translate-y-1/2"
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return _cache[5] || (_cache[5] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
        "class": "lab-line-long-arrow-left text-2xl !font-semibold text-primary"
      }, null, -1 /* HOISTED */)]);
    }),
    _: 1 /* STABLE */
  }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", _hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.verification')), 1 /* TEXT */), $data.errors.validation ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($data.errors.validation), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "absolute top-0 bottom-0 right-0 px-4 py-3 cursor-pointer",
    onClick: _cache[0] || (_cache[0] = function () {
      return _ctx.close && _ctx.close.apply(_ctx, arguments);
    })
  }, _cache[6] || (_cache[6] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "lab lab-close-circle-line margin-top-5-px"
  }, null, -1 /* HOISTED */)]))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_8, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.enter_code')), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    type: "text",
    "onUpdate:modelValue": _cache[1] || (_cache[1] = function ($event) {
      return $data.props.form.token = $event;
    }),
    "class": "w-full h-12 px-4 rounded-lg text-base border border-[#D9DBE9] hover:border-primary/30 focus-within:border-primary/30 transition-all duration-500"
  }, null, 512 /* NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $data.props.form.token]]), $data.errors ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("small", _hoisted_9, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($data.errors), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("small", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.not_receive_code')) + " ", 1 /* TEXT */), $data.props.form.phone ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("button", {
    key: 0,
    onClick: _cache[2] || (_cache[2] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {
      return $options.resendCodeToPhone && $options.resendCodeToPhone.apply($options, arguments);
    }, ["prevent"])),
    type: "button",
    "class": "font-bold text-primary"
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('button.resend_code')), 1 /* TEXT */)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("button", {
    key: 1,
    onClick: _cache[3] || (_cache[3] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {
      return $options.resendCodeToEmail && $options.resendCodeToEmail.apply($options, arguments);
    }, ["prevent"])),
    type: "button",
    "class": "font-bold text-primary"
  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('button.resend_code')), 1 /* TEXT */))])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('button.verify')), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_router_link, {
    "class": "block text-center font-bold text-primary",
    to: {
      name: 'auth.login'
    }
  }, {
    "default": (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(function () {
      return [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.back_to_sign_in')), 1 /* TEXT */)];
    }),
    _: 1 /* STABLE */
  })], 32 /* NEED_HYDRATION */)])], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue":
/*!*********************************************************************************!*\
  !*** ./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ForgotPasswordVerifyComponent_vue_vue_type_template_id_834f54be__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be */ "./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be");
/* harmony import */ var _ForgotPasswordVerifyComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js */ "./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ForgotPasswordVerifyComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ForgotPasswordVerifyComponent_vue_vue_type_template_id_834f54be__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************!*\
  !*** ./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ForgotPasswordVerifyComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ForgotPasswordVerifyComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js */ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be":
/*!***************************************************************************************************************!*\
  !*** ./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be ***!
  \***************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ForgotPasswordVerifyComponent_vue_vue_type_template_id_834f54be__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ForgotPasswordVerifyComponent_vue_vue_type_template_id_834f54be__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be */ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/auth/ForgotPasswordVerifyComponent.vue?vue&type=template&id=834f54be");


/***/ })

}]);