"use strict";
(self["webpackChunk"] = self["webpackChunk"] || []).push([["resources_js_components_frontend_account_returnOrders_ReturnOrderRequestComponent_vue"],{

/***/ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _components_LoadingComponent__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../components/LoadingComponent */ "./resources/js/components/frontend/components/LoadingComponent.vue");
/* harmony import */ var _services_alertService__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../services/alertService */ "./resources/js/services/alertService.js");
/* harmony import */ var _services_appService__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../services/appService */ "./resources/js/services/appService.js");
/* harmony import */ var _enums_modules_statusEnum__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../enums/modules/statusEnum */ "./resources/js/enums/modules/statusEnum.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: "ReturnOrderRequestComponent",
  components: {
    LoadingComponent: _components_LoadingComponent__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data: function data() {
    return {
      loading: {
        isActive: false
      },
      isAllReturn: false,
      form: {
        return_reason_id: null,
        note: "",
        order_id: null,
        order_serial_no: null,
        products: []
      },
      search: {
        paginate: 1,
        page: 1,
        per_page: 10,
        order_column: "id",
        order_type: "desc"
      },
      products: [],
      qty: [],
      image: "",
      errors: {}
    };
  },
  computed: {
    order: function order() {
      return this.$store.getters['frontendOrder/show'];
    },
    orderProducts: function orderProducts() {
      return this.$store.getters['frontendOrder/orderProducts'];
    },
    returnReasons: function returnReasons() {
      return this.$store.getters["frontendReturnReason/lists"];
    }
  },
  mounted: function mounted() {
    var _this = this;
    this.loading.isActive = true;
    if (this.$route.params.id) {
      this.loading.isActive = true;
      this.$store.dispatch("frontendOrder/show", this.$route.params.id).then(function (res) {
        _this.form.order_id = res.data.data.id;
        _this.form.order_serial_no = res.data.data.order_serial_no;
        _this.loading.isActive = false;
      })["catch"](function (error) {
        _this.loading.isActive = false;
      });
      this.$store.dispatch('frontendReturnReason/lists', {
        order_column: 'id',
        order_type: 'asc',
        status: _enums_modules_statusEnum__WEBPACK_IMPORTED_MODULE_3__["default"].ACTIVE
      });
    }
  },
  methods: {
    changeImage: function changeImage(e) {
      this.image = e.target.files;
    },
    onlyNumber: function onlyNumber(e) {
      return _services_appService__WEBPACK_IMPORTED_MODULE_2__["default"].onlyNumber(e);
    },
    close: function close() {
      this.errors.products = "";
    },
    selectAll: function selectAll(e, products) {
      var _this2 = this;
      products.forEach(function (product, i) {
        var quantity = 1;
        var quantityExist = _this2.qty.find(function (p) {
          return p.product_id === product.product_id;
        });
        var quantityIndex = _this2.qty.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        var productData = {
          product_id: product.product_id,
          quantity: quantity,
          price: product.price,
          total: product.total,
          tax: product.tax,
          order_quantity: product.order_quantity,
          return_price: parseFloat(product.quantity * product.price),
          has_variation: product.has_variation,
          variation_id: product.variation_id,
          variation_names: product.variation_names
        };
        if (quantityExist) {
          productData.quantity = _this2.qty[quantityIndex].quantity;
          quantity = _this2.qty[quantityIndex].quantity;
        } else {
          productData.quantity = product.quantity;
          quantity = product.quantity;
        }
        if (_this2.isAllReturn) {
          if (product.is_refundable) {
            product.isReturn = true;
            var productExist = _this2.products.find(function (p) {
              return p.product_id === product.product_id;
            });
            if (productExist) {
              var productIndex = _this2.products.findIndex(function (p) {
                return p.product_id === product.product_id;
              });
              _this2.products.splice(productIndex, 1);
              _this2.products.push(productData);
            } else {
              _this2.products.push(productData);
            }
          }
        } else {
          product.isReturn = false;
          _this2.products = [];
          _this2.qty = [];
        }
      });
    },
    selectProduct: function selectProduct(e, i, product) {
      var quantity = 1;
      var quantityExist = this.qty.find(function (p) {
        return p.product_id === product.product_id;
      });
      var quantityIndex = this.qty.findIndex(function (p) {
        return p.product_id === product.product_id;
      });
      var productData = {
        product_id: product.product_id,
        quantity: quantity,
        price: product.price,
        total: product.total,
        tax: product.tax,
        order_quantity: product.order_quantity,
        return_price: parseFloat(product.quantity * product.price),
        has_variation: product.has_variation,
        variation_id: product.variation_id,
        variation_names: product.variation_names
      };
      if (quantityExist) {
        productData.quantity = this.qty[quantityIndex].quantity;
        quantity = this.qty[quantityIndex].quantity;
      } else {
        productData.quantity = product.quantity;
        quantity = product.quantity;
      }
      if (e.target.checked) {
        this.products.push(productData);
      } else {
        var productIndex = this.products.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        this.products.splice(productIndex, 1);
        this.isAllReturn = false;
      }
    },
    quantityIncrement: function quantityIncrement(i, product) {
      var quantityExist = this.qty.find(function (p) {
        return p.product_id === product.product_id;
      });
      var quantity = 1;
      var quantityIndex = null;
      if (quantityExist) {
        quantityIndex = this.qty.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        if (product.quantity < this.qty[quantityIndex].max_quantity) {
          product.quantity += 1;
        } else {
          product.quantity = this.qty[quantityIndex].max_quantity;
        }
        quantity = product.quantity;
        this.qty[quantityIndex].quantity = quantity;
      }
      var productExist = this.products.find(function (p) {
        return p.product_id === product.product_id;
      });
      if (productExist) {
        var productIndex = this.products.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        this.products[productIndex].quantity = quantity;
        this.products[productIndex].return_price = parseFloat(quantity * product.price);
      }
    },
    quantityDecrement: function quantityDecrement(i, product) {
      var quantityData = {
        product_id: product.product_id,
        quantity: product.quantity,
        max_quantity: product.order_quantity
      };
      if (product.quantity > 1) {
        product.quantity -= 1;
      }
      var quantityExist = this.qty.find(function (p) {
        return p.product_id === product.product_id;
      });
      var quantity = product.quantity;
      var quantityIndex = null;
      if (!quantityExist) {
        quantity = product.quantity;
        if (quantity === 0) {
          quantity = 1;
        }
        quantityData.quantity = quantity;
        this.qty.push(quantityData);
      } else {
        quantityIndex = this.qty.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        if (quantity === 0) {
          quantity = 1;
        }
        this.qty[quantityIndex].quantity = quantity;
      }
      var productExist = this.products.find(function (p) {
        return p.product_id === product.product_id;
      });
      if (productExist) {
        var productIndex = this.products.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        this.products[productIndex].quantity = quantity;
        this.products[productIndex].return_price = parseFloat(quantity * product.price);
      }
    },
    quantityUp: function quantityUp(e, index, product) {
      var quantityData = {
        product_id: product.product_id,
        quantity: product.quantity,
        max_quantity: product.order_quantity
      };
      var quantity = parseInt(e.target.value);
      var quantityIndex = null;
      if (quantity === 0 || quantity < 0) {
        quantity = 1;
        product.quantity = quantity;
      }
      if (quantity > product.order_quantity) {
        quantity = product.order_quantity;
        product.quantity = product.order_quantity;
      }
      var quantityExist = this.qty.find(function (p) {
        return p.product_id === product.product_id;
      });
      if (!quantityExist) {
        quantityData.quantity = quantity;
        this.qty.push(quantityData);
      } else {
        quantityIndex = this.qty.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        this.qty[quantityIndex].quantity = quantity;
      }
      var productExist = this.products.find(function (p) {
        return p.product_id === product.product_id;
      });
      if (productExist) {
        var productIndex = this.products.findIndex(function (p) {
          return p.product_id === product.product_id;
        });
        this.products[productIndex].quantity = quantity;
        this.products[productIndex].return_price = parseFloat(quantity * product.price);
      }
    },
    save: function save() {
      var _this3 = this;
      try {
        var fd = new FormData();
        fd.append('return_reason_id', this.form.return_reason_id !== null ? this.form.return_reason_id : '');
        fd.append('note', this.form.note);
        fd.append('order_id', this.form.order_id);
        fd.append('order_serial_no', this.form.order_serial_no);
        fd.append('products', this.products.length > 0 ? JSON.stringify(this.products) : '');
        if (this.image) {
          for (var i = 0; i < this.image.length; i++) {
            fd.append('image[]', this.image[i]);
          }
        }
        this.loading.isActive = true;
        this.$store.dispatch('frontendReturnAndRefund/save', {
          id: this.$route.params.id,
          form: fd,
          search: this.search
        }).then(function (res) {
          _this3.loading.isActive = false;
          _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].successFlip(0, _this3.$t("menu.return_orders"));
          _this3.form = {
            return_reason_id: null,
            note: "",
            order_id: null,
            order_serial_no: null,
            products: []
          };
          _this3.products = [];
          _this3.qty = [];
          _this3.image = "";
          _this3.errors = {};
          _this3.$refs.imageProperty.value = null;
          _this3.$router.push({
            name: "frontend.account.returnOrders"
          });
        })["catch"](function (err) {
          _this3.loading.isActive = false;
          if (err.response.data.errors === undefined) {
            if (err.response.data.message) {
              _this3.errors = {};
              _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].error(err.response.data.message);
            }
          } else {
            _this3.errors = err.response.data.errors;
          }
        });
      } catch (err) {
        this.loading.isActive = false;
        _services_alertService__WEBPACK_IMPORTED_MODULE_1__["default"].error(err);
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4":
/*!********************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4 ***!
  \********************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm-bundler.js");

var _hoisted_1 = {
  "class": "flex items-center gap-4 mb-7"
};
var _hoisted_2 = {
  "class": "capitalize text-xl font-bold text-primary"
};
var _hoisted_3 = {
  "class": "rounded-2xl shadow-card mb-6 bg-white"
};
var _hoisted_4 = {
  "class": "font-semibold p-4"
};
var _hoisted_5 = {
  key: 0,
  "class": "bg-red-100 border border-red-400 text-red-700 px-4 py-3 mb-5 rounded relative",
  role: "alert"
};
var _hoisted_6 = {
  "class": "block sm:inline"
};
var _hoisted_7 = {
  "class": "mobile:overflow-x-auto"
};
var _hoisted_8 = {
  "class": "w-full text-left text-sm capitalize"
};
var _hoisted_9 = {
  "class": "font-semibold border-b border-t border-gray-200"
};
var _hoisted_10 = {
  "class": "p-4"
};
var _hoisted_11 = {
  "class": "p-4"
};
var _hoisted_12 = {
  "class": "p-4"
};
var _hoisted_13 = {
  key: 0,
  "class": "font-medium"
};
var _hoisted_14 = {
  "class": "p-4 border-b group-last:border-0 border-gray-100"
};
var _hoisted_15 = ["onUpdate:modelValue", "onChange"];
var _hoisted_16 = {
  key: 1,
  "class": "text-danger font-semibold"
};
var _hoisted_17 = {
  "class": "p-4 border-b group-last:border-0 border-gray-100"
};
var _hoisted_18 = {
  "class": "inline-flex items-center gap-3"
};
var _hoisted_19 = ["src"];
var _hoisted_20 = {
  "class": "overflow-hidden"
};
var _hoisted_21 = {
  "class": "text-sm capitalize whitespace-nowrap overflow-hidden text-ellipsis mb-0.5"
};
var _hoisted_22 = {
  key: 0,
  "class": "text-sm capitalize whitespace-nowrap overflow-hidden text-ellipsis"
};
var _hoisted_23 = {
  "class": "p-4 border-b group-last:border-0 border-gray-100"
};
var _hoisted_24 = {
  "class": "flex items-center gap-1 w-20 p-1 rounded-full bg-[#F7F7FC]"
};
var _hoisted_25 = ["onClick"];
var _hoisted_26 = ["id", "onKeyup", "onUpdate:modelValue"];
var _hoisted_27 = ["onClick"];
var _hoisted_28 = {
  "class": "rounded-2xl shadow-card mb-6 p-4 bg-white"
};
var _hoisted_29 = {
  "class": "mb-4"
};
var _hoisted_30 = {
  "for": "return_reason_id",
  "class": "capitalize font-medium mb-2"
};
var _hoisted_31 = {
  key: 0,
  "class": "db-field-alert"
};
var _hoisted_32 = {
  "class": "mb-4"
};
var _hoisted_33 = {
  "for": "note",
  "class": "capitalize font-medium mb-2"
};
var _hoisted_34 = {
  key: 0,
  "class": "db-field-alert"
};
var _hoisted_35 = {
  "class": "capitalize font-medium mb-2"
};
var _hoisted_36 = {
  type: "submit",
  "class": "field-button w-fit font-semibold tracking-wide"
};
function render(_ctx, _cache, $props, $setup, $data, $options) {
  var _component_LoadingComponent = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("LoadingComponent");
  var _component_vue_select = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("vue-select");
  return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_LoadingComponent, {
    props: $data.loading
  }, null, 8 /* PROPS */, ["props"]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_1, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    onClick: _cache[0] || (_cache[0] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function ($event) {
      return _ctx.$router.back();
    }, ["prevent"])),
    "class": "lab-line-undo text-xl font-bold text-primary"
  }), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", _hoisted_2, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.return_request')), 1 /* TEXT */)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("form", {
    "class": "w-full d-block min-h-dvh",
    onSubmit: _cache[8] || (_cache[8] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function () {
      return $options.save && $options.save.apply($options, arguments);
    }, ["prevent"]))
  }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h3", _hoisted_4, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.order_id')) + ": #" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($options.order.order_serial_no), 1 /* TEXT */), $data.errors.products ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_5, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_6, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($data.errors.products[0]), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "absolute top-0 bottom-0 right-0 px-4 py-3 cursor-pointer",
    onClick: _cache[1] || (_cache[1] = function () {
      return $options.close && $options.close.apply($options, arguments);
    })
  }, _cache[9] || (_cache[9] = [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("i", {
    "class": "lab lab-fill-close-circle margin-top-5-px"
  }, null, -1 /* HOISTED */)]))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("table", _hoisted_8, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", _hoisted_9, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", _hoisted_10, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    type: "checkbox",
    "onUpdate:modelValue": _cache[2] || (_cache[2] = function ($event) {
      return $data.isAllReturn = $event;
    }),
    onChange: _cache[3] || (_cache[3] = function ($event) {
      return $options.selectAll($event, $options.orderProducts);
    }),
    "class": "cs-custom-checkbox"
  }, null, 544 /* NEED_HYDRATION, NEED_PATCH */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $data.isAllReturn]])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", _hoisted_11, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.products')), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("th", _hoisted_12, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.quantity')), 1 /* TEXT */)])]), $options.orderProducts.length > 0 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tbody", _hoisted_13, [((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($options.orderProducts, function (product, index) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
      key: index,
      "class": "group"
    }, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_14, [product.is_refundable ? (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("input", {
      key: 0,
      type: "checkbox",
      "onUpdate:modelValue": function onUpdateModelValue($event) {
        return product.isReturn = $event;
      },
      onChange: function onChange($event) {
        return $options.selectProduct($event, index, product);
      },
      "class": "cs-custom-checkbox"
    }, null, 40 /* PROPS, NEED_HYDRATION */, _hoisted_15)), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, product.isReturn]]) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_16, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.not_refundable')), 1 /* TEXT */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_17, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_18, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("img", {
      src: product.product_image,
      alt: "product",
      "class": "w-12 h-12 object-cover rounded-md flex-shrink-0"
    }, null, 8 /* PROPS */, _hoisted_19), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_20, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h4", _hoisted_21, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(product.product_name), 1 /* TEXT */), product.has_variation ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_22, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(product.variation_names), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_23, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_24, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function ($event) {
        return $options.quantityDecrement(index, product);
      }, ["prevent"]),
      type: "button",
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([product.quantity === 1 ? 'cursor-not-allowed text-[#A0A3BD]' : 'text-primary', "lab-fill-circle-minus text-lg leading-none"])
    }, null, 10 /* CLASS, PROPS */, _hoisted_25), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
      type: "number",
      id: 'quantityInput' + index,
      onKeyup: function onKeyup($event) {
        return $options.quantityUp($event, index, product);
      },
      onKeypress: _cache[4] || (_cache[4] = function ($event) {
        return $options.onlyNumber($event);
      }),
      "onUpdate:modelValue": function onUpdateModelValue($event) {
        return product.quantity = $event;
      },
      "class": "text-center w-full h-5 text-sm font-medium"
    }, null, 40 /* PROPS, NEED_HYDRATION */, _hoisted_26), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, product.quantity]]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
      onClick: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withModifiers)(function ($event) {
        return $options.quantityIncrement(index, product);
      }, ["prevent"]),
      type: "button",
      "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([product.quantity === product.order_quantity ? 'cursor-not-allowed text-[#A0A3BD]' : 'text-primary', "lab-fill-circle-plus text-lg leading-none text-[#A0A3BD]"])
    }, null, 10 /* CLASS, PROPS */, _hoisted_27)])])]);
  }), 128 /* KEYED_FRAGMENT */))])) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)])])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_28, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_29, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_30, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.return_reason')) + " ", 1 /* TEXT */), _cache[10] || (_cache[10] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", {
    "class": "text-danger"
  }, "*", -1 /* HOISTED */))]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_vue_select, {
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["field-control appearance-none cursor-pointer", $data.errors.return_reason_id ? 'invalid' : '']),
    id: "return_reason_id",
    modelValue: $data.form.return_reason_id,
    "onUpdate:modelValue": _cache[5] || (_cache[5] = function ($event) {
      return $data.form.return_reason_id = $event;
    }),
    options: $options.returnReasons,
    "label-by": "title",
    "value-by": "id",
    closeOnSelect: true,
    searchable: true,
    clearOnClose: true,
    placeholder: "--",
    "search-placeholder": "--"
  }, null, 8 /* PROPS */, ["class", "modelValue", "options"]), $data.errors.return_reason_id ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("small", _hoisted_31, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($data.errors.return_reason_id[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_32, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_33, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.return_note')), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("textarea", {
    id: "note",
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(["field-control", $data.errors.note ? 'invalid' : '']),
    "onUpdate:modelValue": _cache[6] || (_cache[6] = function ($event) {
      return $data.form.note = $event;
    })
  }, null, 2 /* CLASS */), [[vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $data.form.note]]), $data.errors.note ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("small", _hoisted_34, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($data.errors.note[0]), 1 /* TEXT */)) : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", null, [(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_35, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('label.attachment')), 1 /* TEXT */), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
    onChange: _cache[7] || (_cache[7] = function () {
      return $options.changeImage && $options.changeImage.apply($options, arguments);
    }),
    "class": (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)([$data.errors.image ? 'invalid' : '', "db-field-control"]),
    id: "image",
    type: "file",
    ref: "imageProperty",
    accept: "image/png, image/jpeg, image/jpg",
    multiple: ""
  }, null, 34 /* CLASS, NEED_HYDRATION */)])]), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", _hoisted_36, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(_ctx.$t('button.submit_return')), 1 /* TEXT */)], 32 /* NEED_HYDRATION */)], 64 /* STABLE_FRAGMENT */);
}

/***/ }),

/***/ "./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue":
/*!***********************************************************************************************!*\
  !*** ./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ReturnOrderRequestComponent_vue_vue_type_template_id_336a2fd4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4 */ "./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4");
/* harmony import */ var _ReturnOrderRequestComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ReturnOrderRequestComponent.vue?vue&type=script&lang=js */ "./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ReturnOrderRequestComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ReturnOrderRequestComponent_vue_vue_type_template_id_336a2fd4__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************!*\
  !*** ./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ReturnOrderRequestComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ReturnOrderRequestComponent_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ReturnOrderRequestComponent.vue?vue&type=script&lang=js */ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4":
/*!*****************************************************************************************************************************!*\
  !*** ./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4 ***!
  \*****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ReturnOrderRequestComponent_vue_vue_type_template_id_336a2fd4__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_laravel_mix_node_modules_babel_loader_lib_index_js_clonedRuleSet_5_use_0_node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_2_node_modules_vue_loader_dist_index_js_ruleSet_0_use_0_ReturnOrderRequestComponent_vue_vue_type_template_id_336a2fd4__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!../../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!../../../../../../node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4 */ "./node_modules/laravel-mix/node_modules/babel-loader/lib/index.js??clonedRuleSet-5.use[0]!./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[2]!./node_modules/vue-loader/dist/index.js??ruleSet[0].use[0]!./resources/js/components/frontend/account/returnOrders/ReturnOrderRequestComponent.vue?vue&type=template&id=336a2fd4");


/***/ })

}]);